<?php
 print "GCODE Tools for FlatCAM ver.1.0\n(c)2016 Genryu/SHARA group\n\n"; $help= <<<EOT
** GCODE file extension which is able to be treated is ".ncd".

Usage : gcode_tools <mode> [options]

        <mode>
        size     Get size of GCODE data

                 options: set one file prefix to get size

                 [example]  gcode_tools size abc


        join     Join GCODE files
                 (result will be saved with prefix 'J_')

                 options: set file list to join
                 [example]  gcode_tools join file_1.ncd file_2.ncd .....


        move     Move GCODE data to pointed coodinate
                 (result will be saved with prefix 'M_')

                 options: set one file prefix and axis/length
                 [example]  gcode_tools move abc X 12.432 Y -2.152


        rotate   Rotate GCODE Data with right angle
                 (result will be saved with prefix 'R_')

                 options: set one file prefix
                 [example]  gcode_tools rotate abc


        tile     Tile and join GCODE data
                 (result will be saved with prefix 'T_')

                 options: set one file prefix and tile number X/Y
                 [example]  gcode_tools tile abc 4 1

** Various mode without "join" process simultaneously multiple GCODE files with the same prefix.
** [exampls] abc_hogehoge.ncd, abc_fugafuga.ncd



EOT;
$modlist=array("join","rotate","tile","move","size"); if(count($argv)<2 || !in_array(trim($argv[1]),$modlist)){ echo $help; exit(); } $mode=trim($argv[1]); if($mode!="join"){ $fileprefix=$argv[2]; $size=array("X"=>array("max"=>0,"min"=>0),"Y"=>array("max"=>0,"min"=>0),"Z"=>array("max"=>0,"min"=>0)); $dp=dir("./"); while($filename=$dp->read()){if(substr($filename,0,strlen($fileprefix))==$fileprefix && substr($filename,-3)=="ncd"){$filelist[]=$filename;}} $dp->close(); foreach($filelist as $filename){ foreach(file($filename) as $s){ foreach($size as $key=>$val){ if(preg_match("/".$key."[\ \t]*([\-0-9\.]+)/",$s,$match)>0){$vv=floatval($match[1]);} if($size[$key]["max"]<$vv){$size[$key]["max"]=$vv;} if($size[$key]["min"]>$vv){$size[$key]["min"]=$vv;} $vv=0; } } } foreach($size as $key=>$val){ $size[$key]["len"]=$size[$key]["max"]-$size[$key]["min"]; } } switch($mode){ case "size": foreach($size as $key=>$val){ print $key.":: max:".$val["max"]."  min:".$val["min"]."  len:".$size[$key]["len"]."\n"; } break; case "rotate": foreach($filelist as $filename){ $fp=fopen("R_".$filename,"w"); foreach(file($filename) as $s){ if(preg_match("/X[\ \t]*([\-0-9\.]+)[\ \t]*Y[\ \t]*([\-0-9\.]+)/",$s,$match)>0){ $s=str_replace($match[0],"X".sprintf("%6.4f",$size["Y"]["len"]-floatval($match[2]))." Y".sprintf("%6.4f",floatval($match[1])),$s); } fputs($fp,trim($s)."\n"); } fclose($fp); } echo "completed.\n"; break; case "join": for($i=2;$i<count($argv);$i++){ $fntmp=str_replace(".ncd","",trim($argv[$i])); if($fntmp!=""){$filelist[]=$fntmp;} } $fp=fopen("J_".join("-",$filelist).".ncd","w"); foreach($filelist as $n=>$filename){ foreach(file($filename.".ncd") as $s){ if($n==0 && trim($s)!="M05"){ fputs($fp,trim($s)."\n"); }else{ if(preg_match("/G[\ \t]*([0-9]+)/",$s,$match)>0 && intval($match[1])<4){ fputs($fp,trim($s)."\n"); } } } } fputs($fp,"G00 Z10.000\nG00 X0.0000 Y0.0000\nM05\n"); fclose($fp); echo "completed.\n"; break; case "move": for($i=3;$i<count($argv);$i+=2){$r[trim($argv[$i])]=floatval($argv[$i+1]);} foreach($filelist as $filename){ $fp=fopen("M_".$filename,"w"); foreach(file($filename) as $s){ foreach($r as $key=>$val){ if(preg_match("/".$key."[\ \t]*([\-0-9\.]+)/",$s,$match)>0){ $s=str_replace($match[0],$key.sprintf("%6.4f",floatval($match[1])+$val),$s); } } fputs($fp,trim($s)."\n"); } fclose($fp); } echo "completed.\n"; break; case "tile": $r=array("X"=>intval($argv[3]),"Y"=>intval($argv[4])); foreach($filelist as $filename){ $fp=fopen("T_".$r["X"]."x".$r["Y"]."_".$filename,"w"); for($y=0;$y<$r["Y"];$y++){ for($x=0;$x<$r["X"];$x++){ $a["X"]=$size["X"]["len"]*$x;$a["Y"]=$size["Y"]["len"]*$y; foreach(file($filename) as $s){ if(($x+$y)==0 && trim($s)!="M05"){ fputs($fp,trim($s)."\n"); }else{ if(preg_match("/G[\ \t]*([0-9]+)/",$s,$match)>0 && intval($match[1])<4){ foreach($a as $key=>$val){ if(preg_match("/".$key."[\ \t]*([\-0-9\.]+)/",$s,$match)>0){ $s=str_replace($match[0],$key.sprintf("%6.4f",(floatval($match[1])+$val)),$s); } } fputs($fp,trim($s)."\n"); } } } } } fputs($fp,"G00 Z10.000\nG00 X0.0000 Y0.0000\nM05\n"); fclose($fp); } echo "completed.\n"; break; } ?>
